/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import org.joml.Matrix3x2fStack;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.NarratableComponent;
import snownee.jade.api.ui.TextElement;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.util.JadeLanguages;

public class TextElementImpl
extends TextElement {
    protected final FormattedText text;
    protected float scale = 1.0f;
    protected float alpha = 1.0f;
    private int textWidth;

    public TextElementImpl(Component component) {
        this((FormattedText)component);
    }

    public TextElementImpl(FormattedText text) {
        this.text = text;
        this.width = this.textWidth = Math.max(DisplayHelper.font().width(text), 0);
        Objects.requireNonNull(DisplayHelper.font());
        this.height = 9 - 1;
    }

    @Override
    public TextElement scale(float scale) {
        this.scale = scale;
        this.width = Math.max(Math.round((float)DisplayHelper.font().width(this.text) * scale), 0);
        Objects.requireNonNull(DisplayHelper.font());
        this.height = Math.round(9.0f * scale) - 1;
        return this;
    }

    @Override
    public TextElement alpha(float alpha) {
        this.alpha = alpha;
        return this;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.textLeft();
        int normalColor = IWailaConfig.Overlay.applyAlpha(IThemeHelper.get().getNormalColor(), this.alpha);
        if (this.scale == 1.0f) {
            DisplayHelper.INSTANCE.drawText(graphics, this.text, (float)x, (float)this.getY(), normalColor);
        } else {
            Matrix3x2fStack matrixStack = graphics.pose();
            matrixStack.pushMatrix();
            matrixStack.translate((float)x, (float)this.getY() + this.scale);
            matrixStack.scale(this.scale);
            DisplayHelper.INSTANCE.drawText(graphics, this.text, 0.0f, 0.0f, normalColor);
            matrixStack.popMatrix();
        }
        if (mouseX != -1 && this.getRectangle().containsPoint(mouseX, mouseY)) {
            Style style = DisplayHelper.font().getSplitter().componentStyleAtWidth(this.text, Mth.floor((float)(mouseX - x)));
            graphics.renderComponentHoverEffect(DisplayHelper.font(), style, mouseX, mouseY);
        }
    }

    @Override
    public Component getNarration() {
        return NarratableComponent.getNarration(this.text);
    }

    public String getString() {
        return this.text.getString();
    }

    @Override
    public void setFreeSpace(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        Style style;
        Screen screen = Minecraft.getInstance().screen;
        if (screen != null && (style = DisplayHelper.font().getSplitter().componentStyleAtWidth(this.text, Mth.floor((double)(event.x() - (double)this.textLeft())))) != null) {
            return screen.handleComponentClicked(style);
        }
        return false;
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.textLeft() && mouseX < (double)(this.textLeft() + this.textWidth) && mouseY >= (double)this.getY() && mouseY < (double)(this.getY() + this.height);
    }

    private int textLeft() {
        int x = this.getX();
        if (JadeLanguages.INSTANCE.isRTL()) {
            x += this.width - this.textWidth;
        }
        return x;
    }
}

